<?php namespace App\Controllers\Api\Customer\Profile\Subscribe;

use App\Controllers\PrivateController;
use App\Libraries\Common;
use App\Models\SubscribesModel;
use App\Models\TransactionsModel;
use CodeIgniter\HTTP\ResponseInterface;

define("LIMIT", 20);

class Transactions extends PrivateController
{
    /**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Get subscribe transactions
     * @return ResponseInterface
     */
    public function index(): ResponseInterface
    {
        $subscribe_uid = esc($this->request->getGet("uid"));
        $offset = (int) $this->request->getGet("offset");
      
        $subscribes = new SubscribesModel();

        $subscribe = $subscribes
            ->where("user_id", $this->userId)
            ->where("is_disable", 0)
            ->where("subscribes.uid", $subscribe_uid)
            ->join("plans", "plans.id = subscribes.plan_id")
            ->join("apps", "apps.id = subscribes.app_id")
            ->select("subscribes.subscribe_external_id, subscribes.uid, subscribes.created_at, subscribes.expires_at, subscribes.price, subscribes.is_active, subscribes.remaining_count, apps.name as app_name, apps.uid as app_uid, apps.link as app_link, plans.type, plans.build_count")
            ->first();

        if (!$subscribe) {
            return $this->respond(["message" => lang("Message.message_87")], 404);
        }

        $transactions = new TransactionsModel();
        
        $transactions_list = $transactions
            ->select('transactions.uid, transactions.amount, transactions.created_at, deposit_methods.name as method_name, deposit_methods.logo as method_logo')
            ->join('deposit_methods', 'deposit_methods.id = transactions.method_id')
            ->where('transactions.subscribe_external_id', $subscribe["subscribe_external_id"])
            ->orderBy('transactions.id', 'DESC')
            ->findAll(LIMIT, $offset);

        $items = [];

        if ($transactions_list) {
            foreach ($transactions_list as $item) {
                $items[] = [
                    "uid" => $item["uid"],
                    "amount" => $item["amount"],
                    "method" => [
                        "name" => $item["method_name"],
                        "logo" => base_url("deposit/".$item["method_logo"])
                    ],
                    "created_at" => date('d-m-Y H:i', $item['created_at']),
                ];
            }
        }

        $total = $transactions
            ->where("subscribe_external_id", $subscribe["subscribe_external_id"])
            ->countAllResults();

        $common = new Common();

        $subscribe_item = [
            "uid"        => $subscribe["uid"],
            "created_at" => date('d-m-Y H:i', $subscribe['created_at']),
            "expires_at" => date('d-m-Y H:i', $subscribe['expires_at']),
            "price"      => $subscribe["price"],
            "app"        => [
                "name" => $subscribe["app_name"],
                "uid"  => $subscribe["app_uid"],
                "icon" => $common->get_icon($subscribe["app_uid"]),
                "link" => $subscribe["app_link"]
            ],
            "is_active"  => (bool) $subscribe["is_active"],
            "remaining_count" => $subscribe["remaining_count"] ?? 0,
            "build_count" => $subscribe["build_count"] ?? 0,
            "type" => $subscribe["type"]
        ];

        return $this->respond([
            "list" => $items,
            "total" => $total,
            "subscribe" => $subscribe_item
        ], 200);
    }
}